import pandas as pd
import os
import re
import shutil
import run_alphamelts
from pathlib import Path
from glob import glob #resultsフォルダ内の結果ファイルのソート

# MELTS version
# 1 : rhyolite-MELTS (v. 1.0.2)
# 2 : rhyolite-MELTS (public release v 1.1.0)
# 3 : hyolite-MELTS (public release v 1.2.0)
# 4 : pMELTS (public release v 5.6.1)
version = 4

folder = "results"
datafile = "datafile.xlsx"

df = pd.read_excel(datafile)
non_empty_rows = df.dropna(how='all').shape[0]
print("Number of data：", non_empty_rows)


for calc_n in range(non_empty_rows):
   fname = "melts_results_" + str(calc_n + 1)
   fname2 = fname + ".melts"

   run_alphamelts.input(datafile, fname2, calc_n + 1)
   run_alphamelts.calc(fname2, version)

   old_name = "alphamelts_log.txt"
   new_name = fname + ".txt"
   os.rename(old_name, new_name)
   os.makedirs(folder, exist_ok=True)# 結果保存フォルダを作成（無ければ）
   shutil.move(new_name, os.path.join(folder, new_name))# results フォルダへ移動

run_alphamelts.summary(folder)

